import random
import numpy as np
from scipy.stats import vonmises

class orientationPDFs:
    def __init__(self, distribution_type, params=None):
        self.distribution_type = distribution_type
        self.params = params

    def get_value(self):
        if self.distribution_type == "Constant":
            return self.params["theta"]
        elif self.distribution_type == "Uniform":
            return uniform(self.params["thetaMin"], self.params["thetaMax"])
        elif  self.distribution_type == "Von-Mises":
            theta_min = self.params.get("thetaMin", None)
            theta_max = self.params.get("thetaMax", None)
            return  np.degrees(vonmisesImp(self.params["loc"], self.params["kappa"],theta_min, theta_max))
        else:
            raise ValueError(f"Unknown distribution type: {self.distribution_type}")


def uniform(min,max):
    return random.uniform(min,max)

def vonmisesImp(loc,kappa,min,max):
    value=vonmises(loc=loc, kappa=kappa).rvs()
    while (min is not None and value < min) or (max is not None and value > max):
        value = vonmises(loc=loc, kappa=kappa).rvs()
    return value

